/*
 * Demonstrates that in some cases (and for unknown reasons), the
 * alignment of class members depends on whether they're declared as
 * public or private.  Woe to anyone who attempts to do shady
 * reinterpret casts.  Things might not be where you think they are.
 *
 * All materials here are released under terms of the included
 * COPYRIGHT.txt file.
 * Copyright 2025 by James Carlson <carlsonj@workingcode.com>
 */

#include <iostream>

#ifndef KEYWORD
#define KEYWORD public
#endif

class foo {
KEYWORD:
  int a;
  char b;
public:
  void print3() const {
    std::cout << "a " << ((const char *)&a - (const char *)this) << '\n';
    std::cout << "b " << (&b - (const char *)this) << '\n';
  }
};

class bar : public foo {
KEYWORD:
  // When "public," this object is aligned on an int boundary due to the definition of foo.
  // But when "private" or protected," this is packed right in after the "b" member of foo.
  char c;
public:
  void print2() const {
    print3();
    std::cout << "c " << (&c - (const char *)this) << '\n';
  }
};

class baz : public bar {
KEYWORD:
  // This one, though, somehow does NOT depend on "public" or
  // "private."  It gets packed right in after "c" in the parent bar
  // class in all cases, even though both foo and bar require at least
  // int alignment.
  char d;
public:
  void print() const {
    print2();
    std::cout << "d " << (&d - (const char *)this) << '\n';
  }
};

int
main(int argc, char **argv)
{
  baz bazobj;
  std::cout << "baz " << sizeof(baz) << " foo " << sizeof(foo) << '\n';
  bazobj.print();
  return 0;
}
